/** @type {import('next').NextConfig} */
const nextConfig = {
  // Disable ESLint during build
  eslint: {
    // Warning: This allows production builds to successfully complete even if
    // your project has ESLint errors.
    ignoreDuringBuilds: true,
  },
  // Explicitly enable SWC
  swcMinify: true,
  experimental: {
    forceSwcTransforms: true,
  },
  reactStrictMode: true,
  env: {
    // Server-side environment variables
    FILEMAKER_ODATA_URL1: process.env.FILEMAKER_ODATA_URL1,
    FILEMAKER_USERNAME1: process.env.FILEMAKER_USERNAME1,
    FILEMAKER_PASSWORD1: process.env.FILEMAKER_PASSWORD1,
    FILEMAKER_ODATA_URL2: process.env.FILEMAKER_ODATA_URL2,
    FILEMAKER_USERNAME2: process.env.FILEMAKER_USERNAME2,
    FILEMAKER_PASSWORD2: process.env.FILEMAKER_PASSWORD2,
    
    // Client-side environment variables (prefixed with NEXT_PUBLIC_)
    NEXT_PUBLIC_API_URL: process.env.NEXT_PUBLIC_API_URL || '/api/odata',
  },
  async headers() {
    return [
      {
        // Apply these headers to all routes in your application
        source: '/:path*',
        headers: [
          {
            key: 'Access-Control-Allow-Origin',
            value: '*',
          },
          {
            key: 'Access-Control-Allow-Methods',
            value: 'GET, POST, PUT, PATCH, DELETE, OPTIONS',
          },
          {
            key: 'Access-Control-Allow-Headers',
            value: 'Content-Type, Authorization, OData-Version, Prefer',
          },
        ],
      },
    ];
  },
  async rewrites() {
    return [
      // Rewrite API requests to be handled by our API routes
      {
        source: '/api/odata/:path*',
        destination: '/api/odata/:path*',
      },
    ];
  },
  
  // Enable source maps in development
  productionBrowserSourceMaps: true,
  
  // Log environment variable loading
  webpack: (config, { isServer, dev }) => {
    if (isServer && dev) {
      console.log('Server-side environment variables:');
      console.log('FILEMAKER_ODATA_URL1:', process.env.FILEMAKER_ODATA_URL1 ? 'SET' : 'NOT SET');
      console.log('FILEMAKER_USERNAME1:', process.env.FILEMAKER_USERNAME1 ? 'SET' : 'NOT SET');
      console.log('FILEMAKER_PASSWORD1:', process.env.FILEMAKER_PASSWORD1 ? 'SET' : 'NOT SET');
    }
    return config;
  },
};

module.exports = nextConfig;
