/**
 * Utility functions for checking environment variables
 */

/**
 * Checks if required environment variables are set
 * @returns Object with check results
 */
export function checkEnvironmentVariables() {
  const requiredVars = [
    'FILEMAKER_ODATA_URL1',
    'FILEMAKER_USERNAME1',
    'FILEMAKER_PASSWORD1'
  ];
  
  const results = {
    allSet: true,
    missing: [] as string[],
    details: {} as Record<string, boolean>
  };
  
  for (const varName of requiredVars) {
    const isSet = !!process.env[varName];
    results.details[varName] = isSet;
    
    if (!isSet) {
      results.allSet = false;
      results.missing.push(varName);
    }
  }
  
  return results;
}

/**
 * Logs environment variable status to console
 */
export function logEnvironmentVariables() {
  console.log('Environment Variables Check:');
  console.log('FILEMAKER_ODATA_URL1:', process.env.FILEMAKER_ODATA_URL1 ? 'SET' : 'NOT SET');
  console.log('FILEMAKER_USERNAME1:', process.env.FILEMAKER_USERNAME1 ? 'SET' : 'NOT SET');
  console.log('FILEMAKER_PASSWORD1:', process.env.FILEMAKER_PASSWORD1 ? 'SET' : 'NOT SET');
  console.log('NEXT_PUBLIC_API_URL:', process.env.NEXT_PUBLIC_API_URL || 'NOT SET');
}
