'use client';

import Link from 'next/link';

export default function TestPage() {
  return (
    <div className="min-h-screen bg-gray-50 p-6">
      <div className="max-w-4xl mx-auto">
        <div className="bg-white rounded-lg shadow-lg overflow-hidden">
          <div className="px-6 py-4 border-b border-gray-200">
            <h1 className="text-2xl font-semibold text-gray-900">Test Page</h1>
          </div>
          
          <div className="p-6">
            <p className="text-gray-600 mb-4">
              This is a simple test page to verify that the Vercel deployment is working correctly.
            </p>
            
            <div className="mt-4">
              <Link 
                href="/"
                className="inline-block px-4 py-2 bg-blue-500 text-white rounded hover:bg-blue-600"
              >
                Back to Home
              </Link>
            </div>
          </div>
        </div>
      </div>
    </div>
  );
}
