import Link from 'next/link';

export default function TestPage() {
  return (
    <div className="min-h-screen p-8 bg-gray-50">
      <div className="max-w-4xl mx-auto space-y-6">
        <h1 className="text-3xl font-bold text-gray-900">Test Pages</h1>
        <p className="text-gray-600">Select a test page to verify different aspects of the application.</p>
        
        <div className="grid grid-cols-1 md:grid-cols-2 gap-6 mt-8">
          <Link href="/test/odata" className="block p-6 bg-white rounded-lg shadow-sm border border-gray-200 hover:border-blue-500 hover:shadow-md transition-all">
            <h2 className="text-xl font-semibold text-gray-800">OData Tester</h2>
            <p className="mt-2 text-gray-600">Test OData API endpoints and view responses</p>
          </Link>
          
          <Link href="/test/connection" className="block p-6 bg-white rounded-lg shadow-sm border border-gray-200 hover:border-blue-500 hover:shadow-md transition-all">
            <h2 className="text-xl font-semibold text-gray-800">Connection Tester</h2>
            <p className="mt-2 text-gray-600">Test FileMaker server connection</p>
          </Link>
          
          <Link href="/ztest" className="block p-6 bg-white rounded-lg shadow-sm border border-gray-200 hover:border-blue-500 hover:shadow-md transition-all">
            <h2 className="text-xl font-semibold text-gray-800">OData Advanced Tester</h2>
            <p className="mt-2 text-gray-600">Advanced OData testing with request builder</p>
          </Link>
        </div>
      </div>
    </div>
  );
}
